<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>403 - دسترسی ممنوع - گواهیتو</title>
    <link rel="icon" type="image/png" href="assets/images/logo.png">
    <link href="https://fonts.googleapis.com/css2?family=Vazirmatn:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Vazirmatn', sans-serif;
            background: linear-gradient(135deg, #041c3f 0%, #022847 50%, #041c3f 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            color: #e2e8f0;
            overflow: hidden;
            position: relative;
        }
        
        /* Animated background */
        body::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: 
                radial-gradient(circle at 20% 80%, rgba(4, 28, 63, 0.3) 0%, transparent 50%),
                radial-gradient(circle at 80% 20%, rgba(197, 145, 44, 0.3) 0%, transparent 50%),
                radial-gradient(circle at 40% 40%, rgba(2, 40, 71, 0.2) 0%, transparent 50%);
            animation: backgroundShift 20s ease-in-out infinite;
            z-index: 1;
        }
        
        @keyframes backgroundShift {
            0%, 100% { transform: scale(1) rotate(0deg); }
            50% { transform: scale(1.1) rotate(1deg); }
        }
        
        .container {
            position: relative;
            z-index: 2;
            width: 100%;
            max-width: 500px;
            padding: 2rem;
        }
        
        .glass-card {
            background: rgba(4, 28, 63, 0.6);
            backdrop-filter: blur(20px);
            border: 1px solid rgba(197, 145, 44, 0.3);
            border-radius: 20px;
            padding: 2.5rem;
            margin-bottom: 1.5rem;
            box-shadow: 
                0 8px 32px rgba(4, 28, 63, 0.4),
                inset 0 1px 0 rgba(197, 145, 44, 0.1);
            position: relative;
            overflow: hidden;
        }
        
        .glass-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 1px;
            background: linear-gradient(90deg, transparent, rgba(4, 28, 63, 0.5), transparent);
        }
        
        .error-header {
            text-align: center;
            margin-bottom: 2rem;
        }
        
        .error-code {
            font-size: 4rem;
            font-weight: 800;
            color: #c5912c;
            margin-bottom: 0.5rem;
            text-shadow: 0 0 20px rgba(197, 145, 44, 0.5);
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 1rem;
        }
        
        .forbidden-icon {
            width: 60px;
            height: 60px;
            background: linear-gradient(135deg, #c5912c, #d4a550);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 2rem;
            color: white;
            box-shadow: 0 0 20px rgba(197, 145, 44, 0.5);
        }
        
        .error-title {
            font-size: 1.5rem;
            font-weight: 600;
            color: #c5912c;
            margin-bottom: 0.5rem;
        }
        
        .error-description {
            color: #94a3b8;
            font-size: 1rem;
            line-height: 1.6;
        }
        
        .action-card {
            text-align: center;
        }
        
        .action-message {
            color: #cbd5e1;
            font-size: 1.1rem;
            margin-bottom: 2rem;
            line-height: 1.6;
        }
        
        .home-button {
            display: inline-flex;
            align-items: center;
            gap: 0.75rem;
            background: linear-gradient(135deg, #c5912c 0%, #d4a550 50%, #c5912c 100%);
            background-size: 200% 100%;
            background-position: 0% 0%;
            color: white;
            text-decoration: none;
            padding: 1rem 2rem;
            border-radius: 12px;
            font-weight: 700;
            font-size: 1.1rem;
            transition: all 0.4s ease;
            box-shadow: 0 4px 20px rgba(197, 145, 44, 0.4), 0 0 30px rgba(197, 145, 44, 0.2);
            border: 2px solid rgba(197, 145, 44, 0.3);
            position: relative;
            overflow: hidden;
        }
        
        .home-button::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.2), transparent);
            transition: left 0.5s ease;
        }
        
        .home-button:hover {
            transform: translateY(-3px) scale(1.05);
            box-shadow: 0 8px 30px rgba(197, 145, 44, 0.6), 0 0 40px rgba(197, 145, 44, 0.3);
            background-position: 100% 0%;
            border-color: rgba(197, 145, 44, 0.6);
        }
        
        .home-button:hover::before {
            left: 100%;
        }
        
        .home-button:active {
            transform: translateY(-1px) scale(1.02);
        }
        
        .home-button span {
            font-size: 1.5rem;
            filter: drop-shadow(0 2px 4px rgba(0, 0, 0, 0.2));
        }
        
        .footer {
            text-align: center;
            margin-top: 2rem;
            font-size: 0.875rem;
            line-height: 1.8;
        }
        
        .footer p {
            color: #94a3b8;
        }
        
        .footer .brand-name {
            color: #c5912c;
            font-weight: 700;
            text-shadow: 0 0 10px rgba(197, 145, 44, 0.3);
        }
        
        .footer .admin-panel {
            color: #cbd5e1;
            font-weight: 500;
        }
        
        .footer a {
            color: #c5912c;
            text-decoration: none;
            transition: all 0.3s ease;
            font-weight: 600;
        }
        
        .footer a:hover {
            color: #d4a550;
            text-shadow: 0 0 8px rgba(197, 145, 44, 0.5);
        }
        
        .footer .year {
            color: #94a3b8;
        }
        
        .footer .copyright {
            color: #64748b;
        }
        
        /* Responsive design */
        @media (max-width: 768px) {
            .container {
                padding: 1rem;
            }
            
            .glass-card {
                padding: 2rem;
            }
            
            .error-code {
                font-size: 3rem;
            }
            
            .forbidden-icon {
                width: 50px;
                height: 50px;
                font-size: 1.5rem;
            }
        }
        
        @media (max-width: 480px) {
            .error-code {
                font-size: 2.5rem;
                flex-direction: column;
                gap: 0.5rem;
            }
            
            .glass-card {
                padding: 1.5rem;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Error Information Card -->
        <div class="glass-card error-header">
            <div class="error-code">
                403
                <div class="forbidden-icon">🚫</div>
            </div>
            <h1 class="error-title">دسترسی ممنوع</h1>
            <p class="error-description">متأسفانه شما مجوز دسترسی به این صفحه را ندارید.</p>
        </div>
        
        <!-- Action Card -->
        <div class="glass-card action-card">
            <p class="action-message">شما نمی‌توانید به این بخش دسترسی داشته باشید. لطفاً با مدیر سیستم تماس بگیرید.</p>
            
            <a href="https://gavahito.ir/" class="home-button">
                <span>🏠</span>
                بازگشت به خانه
            </a>
        </div>
        
        <!-- Footer -->
        <div class="footer">
            <p>
                <span class="brand-name">گواهیتو</span> <span class="admin-panel">Admin Panel</span> - 
                <a href="https://gavahito.ir/">gavahito.ir</a> 
                <span class="year">2024</span> <span class="copyright">©</span>
            </p>
        </div>
    </div>
</body>
</html>
