<?php
/**
 * API Endpoint برای بررسی لایسنس افزونه
 */

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Access-Control-Allow-Headers: Content-Type');

require_once __DIR__ . '/../config/database.php';

// دریافت دامنه از درخواست
$domain = isset($_GET['domain']) ? trim($_GET['domain']) : '';
$license_key = isset($_GET['license_key']) ? trim($_GET['license_key']) : '';

// پاک کردن www. از ابتدای دامنه
$domain = preg_replace('/^www\./', '', $domain);
$domain = strtolower(trim($domain));

// حذف پورت اگر وجود دارد
$domain = preg_replace('/:\d+$/', '', $domain);

if (empty($domain)) {
    echo json_encode([
        'valid' => false,
        'message' => 'دامنه ارسال نشده است'
    ], JSON_UNESCAPED_UNICODE);
    exit;
}

try {
    $db = new Database();
    $conn = $db->getConnection();
    
    // بررسی وجود دامنه در دیتابیس
    $stmt = $conn->prepare("SELECT * FROM plugin_licenses WHERE domain = :domain AND status = 'active'");
    $stmt->execute([':domain' => $domain]);
    $license = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($license) {
        // بررسی انقضا (اگر expires_at تنظیم شده باشد)
        if (!empty($license['expires_at'])) {
            $expires_at = strtotime($license['expires_at']);
            $now = time();
            
            if ($expires_at < $now) {
                echo json_encode([
                    'valid' => false,
                    'message' => 'لایسنس منقضی شده است',
                    'expired' => true
                ], JSON_UNESCAPED_UNICODE);
                exit;
            }
        }
        
        // اگر license_key ارسال شده، بررسی تطابق
        if (!empty($license_key) && $license['license_key'] !== $license_key) {
            echo json_encode([
                'valid' => false,
                'message' => 'لایسنس نامعتبر است'
            ], JSON_UNESCAPED_UNICODE);
            exit;
        }
        
        echo json_encode([
            'valid' => true,
            'message' => 'لایسنس معتبر است',
            'license' => [
                'domain' => $license['domain'],
                'status' => $license['status'],
                'expires_at' => $license['expires_at']
            ]
        ], JSON_UNESCAPED_UNICODE);
    } else {
        echo json_encode([
            'valid' => false,
            'message' => 'لایسنس برای این دامنه یافت نشد'
        ], JSON_UNESCAPED_UNICODE);
    }
    
} catch (Exception $e) {
    error_log("License check error: " . $e->getMessage());
    echo json_encode([
        'valid' => false,
        'message' => 'خطا در بررسی لایسنس'
    ], JSON_UNESCAPED_UNICODE);
}
?>

