<?php
/**
 * reCAPTCHA Configuration
 * تنظیمات reCAPTCHA
 */

// reCAPTCHA v3 Configuration
define('RECAPTCHA_SITE_KEY', '6LdkbCMsAAAAAIrr50KTqlu3xlvfARB7suD_zvsR');
define('RECAPTCHA_SECRET_KEY', '6LdkbCMsAAAAABJcneKXehOVjmvl5rd2DF1HCczY');

// reCAPTCHA verification URL
define('RECAPTCHA_VERIFY_URL', 'https://www.google.com/recaptcha/api/siteverify');

/**
 * Verify reCAPTCHA token
 * تایید توکن reCAPTCHA
 * 
 * @param string $token The reCAPTCHA token
 * @return array Response with success status and score
 */
function verifyRecaptcha($token) {
    if (empty($token)) {
        return ['success' => false, 'message' => 'توکن reCAPTCHA ارسال نشده است'];
    }
    
    $data = [
        'secret' => RECAPTCHA_SECRET_KEY,
        'response' => $token,
        'remoteip' => getClientIP()
    ];
    
    $options = [
        'http' => [
            'header' => "Content-type: application/x-www-form-urlencoded\r\n",
            'method' => 'POST',
            'content' => http_build_query($data)
        ]
    ];
    
    $context = stream_context_create($options);
    $response = file_get_contents(RECAPTCHA_VERIFY_URL, false, $context);
    
    if ($response === false) {
        return ['success' => false, 'message' => 'خطا در ارتباط با سرور reCAPTCHA'];
    }
    
    $responseData = json_decode($response, true);
    
    if (!$responseData) {
        return ['success' => false, 'message' => 'پاسخ نامعتبر از سرور reCAPTCHA'];
    }
    
    if (!$responseData['success']) {
        $errorCodes = $responseData['error-codes'] ?? [];
        $errorMessage = 'خطا در تایید reCAPTCHA';
        
        if (in_array('invalid-input-secret', $errorCodes)) {
            $errorMessage = 'کلید secret نامعتبر است';
        } elseif (in_array('invalid-input-response', $errorCodes)) {
            $errorMessage = 'توکن reCAPTCHA نامعتبر است';
        } elseif (in_array('timeout-or-duplicate', $errorCodes)) {
            $errorMessage = 'توکن reCAPTCHA منقضی شده یا تکراری است';
        }
        
        return ['success' => false, 'message' => $errorMessage];
    }
    
    // Check score (reCAPTCHA v3 returns a score between 0.0 and 1.0)
    $score = $responseData['score'] ?? 0;
    $minScore = 0.5; // حداقل امتیاز قابل قبول
    
    if ($score < $minScore) {
        return [
            'success' => false, 
            'message' => 'امتیاز reCAPTCHA پایین است (امتیاز: ' . round($score, 2) . ')',
            'score' => $score
        ];
    }
    
    return [
        'success' => true,
        'message' => 'reCAPTCHA با موفقیت تایید شد',
        'score' => $score
    ];
}

/**
 * Get client IP address (if not already defined)
 * دریافت آدرس IP کاربر (اگر قبلاً تعریف نشده باشد)
 * 
 * @return string
 */
if (!function_exists('getClientIP')) {
    function getClientIP() {
        $ipKeys = ['HTTP_CLIENT_IP', 'HTTP_X_FORWARDED_FOR', 'HTTP_X_FORWARDED', 'HTTP_X_CLUSTER_CLIENT_IP', 'HTTP_FORWARDED_FOR', 'HTTP_FORWARDED', 'REMOTE_ADDR'];
        
        foreach ($ipKeys as $key) {
            if (array_key_exists($key, $_SERVER) === true) {
                foreach (explode(',', $_SERVER[$key]) as $ip) {
                    $ip = trim($ip);
                    if (filter_var($ip, FILTER_VALIDATE_IP, FILTER_FLAG_NO_PRIV_RANGE | FILTER_FLAG_NO_RES_RANGE) !== false) {
                        return $ip;
                    }
                }
            }
        }
        
        return $_SERVER['REMOTE_ADDR'] ?? '0.0.0.0';
    }
}
?>
