<?php
/**
 * SMTP Configuration for گواهیتو Admin Panel
 * تنظیمات SMTP برای پنل مدیریت گواهیتو
 */

// SMTP Settings - تنظیمات SMTP
define('SMTP_ENABLED', true); // فعال/غیرفعال کردن SMTP
define('SMTP_HOST', 'mail.gavahito.ir'); // آدرس سرور SMTP
define('SMTP_PORT', 587); // پورت SMTP (TLS)
define('SMTP_SECURE', 'TLS'); // نوع امنیت (tls یا ssl)
define('SMTP_USERNAME', 'info@gavahito.ir'); // نام کاربری SMTP
define('SMTP_PASSWORD', ')s-%&SyYk[la!nm='); // رمز عبور SMTP
define('SMTP_FROM_EMAIL', 'info@gavahito.ir'); // ایمیل فرستنده (از سرور SMTP)
define('SMTP_FROM_NAME', 'Gavahito'); // نام فرستنده

// Alternative SMTP Providers - ارائه‌دهندگان جایگزین SMTP
$smtpProviders = [
    'gmail' => [
        'host' => 'smtp.gmail.com',
        'port' => 587,
        'secure' => 'tls',
        'username' => 'your-email@gmail.com',
        'password' => 'your-app-password'
    ],
    'yahoo' => [
        'host' => 'smtp.mail.yahoo.com',
        'port' => 587,
        'secure' => 'tls',
        'username' => 'your-email@yahoo.com',
        'password' => 'your-app-password'
    ],
    'outlook' => [
        'host' => 'smtp-mail.outlook.com',
        'port' => 587,
        'secure' => 'tls',
        'username' => 'your-email@outlook.com',
        'password' => 'your-password'
    ],
    'sendgrid' => [
        'host' => 'smtp.sendgrid.net',
        'port' => 587,
        'secure' => 'tls',
        'username' => 'apikey',
        'password' => 'your-sendgrid-api-key'
    ]
];

// Get SMTP configuration
function getSMTPConfig($provider = 'gmail') {
    global $smtpProviders;
    
    if (isset($smtpProviders[$provider])) {
        return $smtpProviders[$provider];
    }
    
    // Return default Gmail config
    return $smtpProviders['gmail'];
}



// Check if email was recently sent to prevent spam
function checkEmailRateLimit($to, $subject, $timeWindowMinutes = 5) {
    try {
        require_once __DIR__ . '/../config/database.php';
        $db = new Database();
        $conn = $db->getConnection();
        
        // Check if email_logs table exists, create if not (with compatibility for existing structure)
        try {
            $checkTableQuery = "SHOW TABLES LIKE 'email_logs'";
            $checkStmt = $conn->query($checkTableQuery);
            if ($checkStmt->rowCount() == 0) {
                $createTableQuery = "CREATE TABLE IF NOT EXISTS email_logs (
                    id INT AUTO_INCREMENT PRIMARY KEY,
                    recipient VARCHAR(255) NOT NULL,
                    subject VARCHAR(500),
                    severity ENUM('low', 'medium', 'high', 'critical') DEFAULT 'medium',
                    sent_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
                    INDEX idx_recipient_time (recipient, sent_at),
                    INDEX idx_recipient (recipient),
                    INDEX idx_sent_at (sent_at)
                ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";
                $conn->exec($createTableQuery);
            }
        } catch (Exception $e) {
            // Table might already exist with different structure, continue
            error_log("Email logs table check: " . $e->getMessage());
        }
        
        // Check for duplicate emails in the time window
        $checkQuery = "SELECT COUNT(*) as count FROM email_logs 
                      WHERE recipient = ? 
                      AND subject = ? 
                      AND sent_at >= DATE_SUB(NOW(), INTERVAL ? MINUTE)";
        $checkStmt = $conn->prepare($checkQuery);
        $checkStmt->execute([$to, $subject, $timeWindowMinutes]);
        $result = $checkStmt->fetch(PDO::FETCH_ASSOC);
        
        if ($result && $result['count'] > 0) {
            error_log("Email rate limit exceeded: Duplicate email to $to with subject '$subject' in last $timeWindowMinutes minutes");
            return false;
        }
        
        // Check total emails sent to this recipient in last hour
        $hourlyCheckQuery = "SELECT COUNT(*) as count FROM email_logs 
                            WHERE recipient = ? 
                            AND sent_at >= DATE_SUB(NOW(), INTERVAL 1 HOUR)";
        $hourlyStmt = $conn->prepare($hourlyCheckQuery);
        $hourlyStmt->execute([$to]);
        $hourlyResult = $hourlyStmt->fetch(PDO::FETCH_ASSOC);
        
        // Limit: max 10 emails per hour per recipient
        if ($hourlyResult && $hourlyResult['count'] >= 10) {
            error_log("Email rate limit exceeded: Too many emails to $to in last hour");
            return false;
        }
        
        return true;
    } catch (Exception $e) {
        error_log("Email rate limit check error: " . $e->getMessage());
        return true; // Allow if check fails
    }
}

// Log email sent
function logEmailSent($to, $subject, $severity = 'medium') {
    try {
        require_once __DIR__ . '/../config/database.php';
        $db = new Database();
        $conn = $db->getConnection();
        
        // Check if severity column exists
        try {
            $checkColumnQuery = "SHOW COLUMNS FROM email_logs LIKE 'severity'";
            $checkColumnStmt = $conn->query($checkColumnQuery);
            $hasSeverityColumn = $checkColumnStmt->rowCount() > 0;
        } catch (Exception $e) {
            $hasSeverityColumn = false;
        }
        
        if ($hasSeverityColumn) {
            $logQuery = "INSERT INTO email_logs (recipient, subject, severity) VALUES (?, ?, ?)";
            $logStmt = $conn->prepare($logQuery);
            $logStmt->execute([$to, $subject, $severity]);
        } else {
            $logQuery = "INSERT INTO email_logs (recipient, subject) VALUES (?, ?)";
            $logStmt = $conn->prepare($logQuery);
            $logStmt->execute([$to, $subject]);
        }
        
        // Clean old logs (keep last 7 days)
        $cleanQuery = "DELETE FROM email_logs WHERE sent_at < DATE_SUB(NOW(), INTERVAL 7 DAY)";
        $conn->exec($cleanQuery);
    } catch (Exception $e) {
        error_log("Email log error: " . $e->getMessage());
    }
}

// Send email using SMTP with improved error handling and spam prevention
function sendEmailSMTP($to, $subject, $message, $replyTo = '', $attachmentPath = null) {
    if (!SMTP_ENABLED) {
        error_log("SMTP is disabled");
        return false;
    }
    
    // Check rate limit before sending
    if (!checkEmailRateLimit($to, $subject, 5)) {
        error_log("Email not sent due to rate limit: $to - $subject");
        return false;
    }
    
    try {
        // Include PHPMailer with proper error handling
        $phpmailerPath = __DIR__ . '/../vendor/phpmailer/phpmailer/src/';
        
        if (!file_exists($phpmailerPath . 'PHPMailer.php')) {
            error_log("PHPMailer files not found at: $phpmailerPath");
            return false;
        }
        
        // Include PHPMailer classes
        require_once $phpmailerPath . 'Exception.php';
        require_once $phpmailerPath . 'PHPMailer.php';
        require_once $phpmailerPath . 'SMTP.php';
        
        // Check if PHPMailer class exists
        if (!class_exists('PHPMailer\PHPMailer\PHPMailer')) {
            error_log("PHPMailer class not found after including files");
            return false;
        }
        
        $mail = new PHPMailer\PHPMailer\PHPMailer(true);
        
        // Disable debug mode for production
        $mail->SMTPDebug = 0;
        $mail->Debugoutput = 'error_log';
        
        // Server settings
        $mail->isSMTP();
        $mail->Host = SMTP_HOST;
        $mail->SMTPAuth = true;
        $mail->Username = SMTP_USERNAME;
        $mail->Password = SMTP_PASSWORD;
        $mail->SMTPSecure = SMTP_SECURE;
        $mail->Port = SMTP_PORT;
        $mail->CharSet = 'UTF-8';
        
        // Set timeout
        $mail->Timeout = 30;
        $mail->SMTPKeepAlive = false;
        
        // Anti-spam headers - هدرهای ضد اسپم
        $mail->XMailer = 'Gavahito Mail System';
        $mail->Priority = 3; // Normal priority
        
        // Add anti-spam headers
        $mail->addCustomHeader('X-Priority', '3');
        $mail->addCustomHeader('X-MSMail-Priority', 'Normal');
        $mail->addCustomHeader('Importance', 'Normal');
        $mail->addCustomHeader('List-Unsubscribe', '<mailto:' . SMTP_FROM_EMAIL . '?subject=Unsubscribe>');
        $mail->addCustomHeader('List-Unsubscribe-Post', 'List-Unsubscribe=One-Click');
        $mail->addCustomHeader('Precedence', 'bulk');
        $mail->addCustomHeader('Auto-Submitted', 'auto-generated');
        
        // Recipients
        $mail->setFrom(SMTP_FROM_EMAIL, SMTP_FROM_NAME);
        $mail->addAddress($to);
        
        if (!empty($replyTo)) {
            $mail->addReplyTo($replyTo);
        } else {
            $mail->addReplyTo(SMTP_FROM_EMAIL, SMTP_FROM_NAME);
        }
        
        // Content
        $mail->isHTML(true);
        $mail->Subject = $subject;
        $mail->Body = $message;
        $mail->AltBody = strip_tags($message);
        
        // Word wrap for better compatibility
        $mail->WordWrap = 70;
        
        // Add attachment if provided
        if (!empty($attachmentPath) && file_exists(__DIR__ . '/../' . $attachmentPath)) {
            $fullPath = __DIR__ . '/../' . $attachmentPath;
            $mail->addAttachment($fullPath, basename($attachmentPath));
        }
        
        // Send email
        $result = $mail->send();
        
        if ($result) {
            // Log successful email send
            logEmailSent($to, $subject);
            error_log("Email sent successfully via SMTP to: $to");
            
            // Add small delay to prevent rapid sending (anti-spam)
            usleep(500000); // 0.5 second delay
            
            return true;
        } else {
            error_log("Failed to send email via SMTP to: $to");
            return false;
        }
        
    } catch (Exception $e) {
        error_log("SMTP Error: " . $e->getMessage());
        return false;
    }
}

// Send email with fallback and improved error handling
function sendEmailWithFallback($to, $subject, $message, $replyTo = '', $attachmentPath = null) {
    error_log("Attempting to send email to: $to");
    
    // Try SMTP first
    if (SMTP_ENABLED) {
        error_log("Trying SMTP method...");
        $result = sendEmailSMTP($to, $subject, $message, $replyTo, $attachmentPath);
        if ($result) {
            error_log("Email sent successfully via SMTP");
            return true;
        } else {
            error_log("SMTP failed, trying fallback method...");
        }
    }
    
    // Check rate limit before fallback
    if (!checkEmailRateLimit($to, $subject, 5)) {
        error_log("Email not sent due to rate limit (fallback): $to - $subject");
        return false;
    }
    
    // Fallback to PHP mail function with anti-spam headers
    error_log("Trying PHP mail() function...");
    $headers = "MIME-Version: 1.0\r\n";
    $headers .= "Content-Type: text/html; charset=UTF-8\r\n";
    $headers .= "From: " . SMTP_FROM_NAME . " <" . SMTP_FROM_EMAIL . ">\r\n";
    
    if (!empty($replyTo)) {
        $headers .= "Reply-To: $replyTo\r\n";
    } else {
        $headers .= "Reply-To: " . SMTP_FROM_EMAIL . "\r\n";
    }
    
    // Anti-spam headers
    $headers .= "X-Mailer: Gavahito Mail System\r\n";
    $headers .= "X-Priority: 3\r\n";
    $headers .= "X-MSMail-Priority: Normal\r\n";
    $headers .= "Importance: Normal\r\n";
    $headers .= "List-Unsubscribe: <mailto:" . SMTP_FROM_EMAIL . "?subject=Unsubscribe>\r\n";
    $headers .= "List-Unsubscribe-Post: List-Unsubscribe=One-Click\r\n";
    $headers .= "Precedence: bulk\r\n";
    $headers .= "Auto-Submitted: auto-generated\r\n";
    
    $result = mail($to, $subject, $message, $headers);
    
    if ($result) {
        // Log successful email send
        logEmailSent($to, $subject);
        error_log("Email sent successfully via PHP mail()");
        
        // Add small delay to prevent rapid sending (anti-spam)
        usleep(500000); // 0.5 second delay
        
        return true;
    } else {
        error_log("Failed to send email via PHP mail()");
        return false;
    }
}


?>
