-- Two-Factor Authentication Schema
-- اسکیمای احراز هویت دو مرحله‌ای

CREATE TABLE IF NOT EXISTS verification_codes (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT NOT NULL,
    code VARCHAR(6) NOT NULL,
    email VARCHAR(255) NOT NULL,
    expires_at TIMESTAMP NOT NULL,
    is_used TINYINT(1) DEFAULT 0,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    used_at TIMESTAMP NULL,
    INDEX idx_user_code (user_id, code),
    INDEX idx_expires (expires_at),
    FOREIGN KEY (user_id) REFERENCES admin_users(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Add 2FA settings to system_settings table
INSERT INTO system_settings (setting_key, setting_value, created_at) VALUES 
('2fa_enabled', '1', NOW()),
('2fa_code_expiry', '300', NOW()),
('2fa_email_template', 'کد تایید ورود شما: {code}', NOW())
ON DUPLICATE KEY UPDATE setting_value = VALUES(setting_value);
