-- Add columns for file attachments and admin responses
-- اضافه کردن ستون‌ها برای فایل‌های ضمیمه و پاسخ ادمین
-- Note: Duplicate column errors will be ignored in install.php

-- Add columns to bug_reports table
ALTER TABLE bug_reports 
ADD COLUMN attachment_path VARCHAR(500) NULL AFTER description;

ALTER TABLE bug_reports 
ADD COLUMN admin_response TEXT NULL AFTER status;

ALTER TABLE bug_reports 
ADD COLUMN response_sent_at TIMESTAMP NULL AFTER admin_response;

-- Add columns to feature_requests table
ALTER TABLE feature_requests 
ADD COLUMN attachment_path VARCHAR(500) NULL AFTER description;

ALTER TABLE feature_requests 
ADD COLUMN admin_response TEXT NULL AFTER status;

ALTER TABLE feature_requests 
ADD COLUMN response_sent_at TIMESTAMP NULL AFTER admin_response;

-- Create indexes for better performance
CREATE INDEX idx_bug_reports_response ON bug_reports(response_sent_at);
CREATE INDEX idx_feature_requests_response ON feature_requests(response_sent_at);

