-- ایجاد جدول مدیریت لایسنس
CREATE TABLE IF NOT EXISTS `plugin_licenses` (
    `id` INT PRIMARY KEY AUTO_INCREMENT,
    `domain` VARCHAR(255) NOT NULL UNIQUE,
    `license_key` VARCHAR(255) NOT NULL UNIQUE,
    `status` ENUM('active', 'inactive', 'suspended') DEFAULT 'active',
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    `expires_at` TIMESTAMP NULL,
    `notes` TEXT,
    INDEX `idx_domain` (`domain`),
    INDEX `idx_license_key` (`license_key`),
    INDEX `idx_status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

